jQuery(document).ready(function ($) {
    console.log('HRM Admin JS Loaded');

    // --- Add Employee Modal Logic ---

    const $modal = $('#hrm-add-employee-modal');
    const $openBtn = $('#hrm-add-employee-btn');
    const $closeBtn = $('.hrm-modal-close, .hrm-modal-cancel');
    const $form = $('#hrm-add-employee-form');

    // Open Modal
    $openBtn.on('click', function (e) {
        e.preventDefault();
        $modal.fadeIn(200);
    });

    // Close Modal
    $closeBtn.on('click', function (e) {
        e.preventDefault();
        $modal.fadeOut(200);
    });

    // Close on click outside
    $modal.on('click', function (e) {
        if ($(e.target).is($modal)) {
            $modal.fadeOut(200);
        }
    });

    // --- Global Utilities ---
    window.hrmToast = window.hrmToast || function (type, message) {
        if (window.HRM_UI_Enhancer && typeof window.HRM_UI_Enhancer.showToast === 'function') {
            window.HRM_UI_Enhancer.showToast(message, type);
        } else {
            const icon = type === 'success' ? 'dashicons-yes-alt' : 'dashicons-warning';
            const html = `
                <div class="hrm-toast-notification ${type}">
                    <span class="dashicons ${icon}"></span>
                    <span>${message}</span>
                    <button class="hrm-toast-close" onclick="this.parentElement.remove()">&times;</button>
                </div>`;
            $('body').append(html);
            setTimeout(() => {
                $('.hrm-toast-notification').fadeOut(function () { $(this).remove(); });
            }, 4000);
        }
    };

    // --- Add Employee Form Logic ---
    const $addEmployeeForm = $('#hrm-add-employee-form');

    if ($addEmployeeForm.length) {
        $addEmployeeForm.on('submit', function (e) {
            e.preventDefault();
            const $form = $(this);
            const $submitBtn = $form.find('button[type="submit"]');
            const originalBtnContent = $submitBtn.html();

            // Handle loading state
            $submitBtn.prop('disabled', true);
            if ($submitBtn.find('.btn-content').length) {
                $submitBtn.find('.btn-content').hide();
                $submitBtn.find('.btn-loading').show();
            } else {
                $submitBtn.addClass('loading').text('Processing...');
            }

            const formData = new FormData(this);
            // Ensure action is present
            if (!formData.has('action')) {
                formData.append('action', 'hrm_add_employee');
            }

            $.ajax({
                url: typeof hrm_admin_params !== 'undefined' ? hrm_admin_params.ajaxurl : ajaxurl,
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function (response) {
                    if (response.success) {
                        hrmToast('success', response.data.message || 'Employee created successfully!');
                        setTimeout(() => {
                            window.location.href = 'admin.php?page=hrm-employees';
                        }, 1500);
                    } else {
                        // Check if showHrmModal (from inline script) exists, else use toast
                        if (typeof window.showHrmModal === 'function') {
                            window.showHrmModal('error', 'Error', response.data);
                        } else {
                            hrmToast('error', response.data || 'Failed to create employee.');
                        }
                        resetSubmitBtn($submitBtn, originalBtnContent);
                    }
                },
                error: function () {
                    hrmToast('error', 'Server error. Please try again.');
                    resetSubmitBtn($submitBtn, originalBtnContent);
                }
            });
        });
    }

    function resetSubmitBtn($btn, content) {
        $btn.prop('disabled', false).removeClass('loading');
        if ($btn.find('.btn-content').length) {
            $btn.find('.btn-content').show();
            $btn.find('.btn-loading').hide();
        } else {
            $btn.html(content);
        }
    }

    // --- Search and Filter Logic ---
    const $searchInput = $('.hrm-search-input');
    const $deptFilter = $('.hrm-select-input');
    const $cards = $('.hrm-employee-card');

    function filterEmployees() {
        const searchTerm = $searchInput.val().toLowerCase();
        const selectedDept = $deptFilter.val();

        // 1. Filter Cards (Employee Grid)
        if ($cards.length) {
            $cards.each(function () {
                const $card = $(this);
                const name = $card.data('name').toLowerCase();
                const dept = $card.data('department');
                const matchesSearch = name.includes(searchTerm);
                const matchesDept = !selectedDept || selectedDept === 'All Departments' || dept === selectedDept;
                $card.toggle(matchesSearch && matchesDept);
            });
        }

        // 2. Filter Table Rows (Attendance Table)
        const $rows = $('.hrm-table tbody tr');
        if ($rows.length) {
            $rows.each(function () {
                const $row = $(this);
                // Assume first column is name
                const text = $row.find('td:first').text().toLowerCase();
                if (text.includes(searchTerm)) {
                    $row.show();
                } else {
                    $row.hide();
                }
            });
        }
    }

    if ($searchInput.length) {
        $searchInput.on('input', filterEmployees);
        $deptFilter.on('change', filterEmployees);
    }

    // --- Edit Employee Modal Logic ---
    const $editModal = $('#hrm-edit-employee-modal');
    const $editBtn = $('#hrm-edit-employee-btn');
    const $editForm = $('#hrm-edit-employee-form');

    if ($editBtn.length) {
        $editBtn.on('click', function (e) {
            e.preventDefault();
            $editModal.fadeIn(200);
        });

        // Close logic is handled by the shared .hrm-modal-close class

        $editModal.on('click', function (e) {
            if ($(e.target).is($editModal)) {
                $editModal.fadeOut(200);
            }
        });

        $editForm.on('submit', function (e) {
            e.preventDefault();

            const $submitBtn = $(this).find('button[type="submit"]');
            $submitBtn.addClass('loading').prop('disabled', true);

            const formData = {
                action: 'hrm_edit_employee',
                employee_id: $(this).find('input[name="employee_id"]').val(),
                name: $(this).find('input[name="name"]').val(),
                position: $(this).find('input[name="position"]').val(),
                email: $(this).find('input[name="email"]').val(),
                phone: $(this).find('input[name="phone"]').val(),
                department: $(this).find('select[name="department"]').val()
            };

            $.post(ajaxurl, formData, function (response) {
                if (response.success) {
                    location.reload();
                } else {
                    alert('Error: ' + response.data);
                    $submitBtn.removeClass('loading').prop('disabled', false);
                }
            }).fail(function () {
                alert('Server error. Please try again.');
                $submitBtn.removeClass('loading').prop('disabled', false);
            });
        });
    }

    // --- Add Task Modal Logic ---
    const $taskModal = $('#hrm-add-task-modal');
    const $taskBtn = $('#hrm-add-task-btn');

    if ($taskBtn.length) {
        $taskBtn.on('click', function (e) {
            e.preventDefault();
            $taskModal.fadeIn(200);
        });

        $taskModal.on('click', function (e) {
            if ($(e.target).is($taskModal)) {
                $taskModal.fadeOut(200);
            }
        });
    }

    // --- Auto-open Add Employee Modal if URL param exists ---
    const urlParams = new URLSearchParams(window.location.search);
    if (urlParams.get('action') === 'add_new') {
        if ($openBtn.length) {
            $openBtn.click();
        }
    }

    // --- Multi-Email Tag Input Logic ---
    const $emailInput = $('#hrm-email-input');
    const $emailTagsContainer = $('#hrm-email-tags');
    const $hiddenEmailInput = $('#hrm-notification-email-hidden');

    if ($emailInput.length) {
        let emails = $hiddenEmailInput.val() ? $hiddenEmailInput.val().split(',') : [];

        // Filter out empty strings
        emails = emails.filter(e => e.trim() !== '');

        function renderTags() {
            $emailTagsContainer.empty();
            emails.forEach((email, index) => {
                const $tag = $(`
                    <div class="hrm-tag">
                        ${email}
                        <span class="hrm-tag-close" data-index="${index}">&times;</span>
                    </div>
                `);
                $emailTagsContainer.append($tag);
            });
            $hiddenEmailInput.val(emails.join(','));
        }

        function validateEmail(email) {
            const re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            return re.test(email);
        }

        $emailInput.on('keydown', function (e) {
            if (e.key === 'Enter' || e.key === ',') {
                e.preventDefault();
                const email = $(this).val().trim();

                if (email && validateEmail(email)) {
                    if (!emails.includes(email)) {
                        emails.push(email);
                        renderTags();
                    }
                    $(this).val('');
                } else if (email) {
                    alert('Please enter a valid email address.');
                }
            }
            // Backspace to remove last tag if input is empty
            if (e.key === 'Backspace' && $(this).val() === '' && emails.length > 0) {
                emails.pop();
                renderTags();
            }
        });

        // Remove tag on click
        $emailTagsContainer.on('click', '.hrm-tag-close', function () {
            const index = $(this).data('index');
            emails.splice(index, 1);
            renderTags();
        });

        // Initial render
        renderTags();
    }

    // --- Edit Attendance Logic (Added) ---
    const $editAttModal = $('#hrm-edit-attendance-modal');
    const $editAttForm = $('#hrm-edit-attendance-form');

    $(document).on('click', '.hrm-edit-attendance-btn', function (e) {
        e.preventDefault();
        const btn = $(this);

        $('#edit_record_id').val(btn.data('id'));
        $('#edit_date').val(btn.data('date'));
        $('#edit_check_in').val(btn.data('in'));
        $('#edit_check_out').val(btn.data('out'));
        $('#edit_status').val(btn.data('status'));

        $editAttModal.fadeIn(200);
    });

    // Close logic for attendance modal
    $editAttModal.on('click', function (e) {
        if ($(e.target).is($editAttModal) || $(e.target).hasClass('hrm-modal-close')) {
            $editAttModal.fadeOut(200);
        }
    });

    $editAttForm.on('submit', function (e) {
        e.preventDefault();
        const $submitBtn = $(this).find('button[type="submit"]');
        $submitBtn.addClass('loading').prop('disabled', true);

        const formData = {
            action: 'hrm_edit_attendance',
            nonce: hrm_admin_params.nonce,
            record_id: $('#edit_record_id').val(),
            date: $('#edit_date').val(),
            check_in: $('#edit_check_in').val(),
            check_out: $('#edit_check_out').val(),
            status: $('#edit_status').val()
        };

        $.post(hrm_admin_params.ajaxurl || ajaxurl, formData, function (response) {
            if (response.success) {
                location.reload();
            } else {
                alert('Error: ' + (response.data || 'Unknown error'));
                $submitBtn.removeClass('loading').prop('disabled', false);
            }
        }).fail(function () {
            alert('Server Error');
            $submitBtn.removeClass('loading').prop('disabled', false);
        });
    });

    // --- Manual Attendance Logic ---
    const $manualAttModal = $('#hrm-manual-attendance-modal');
    const $manualAttForm = $('#manual-attendance-form');

    // Form Submit
    $manualAttForm.on('submit', function (e) {
        e.preventDefault();
        const $submitBtn = $(this).find('button[type="submit"]');
        $submitBtn.addClass('loading').prop('disabled', true);

        const formData = {
            action: 'hrm_manual_attendance',
            nonce: hrm_admin_params.nonce,
            employee_id: $(this).find('select[name="employee_id"]').val(),
            date: $(this).find('input[name="date"]').val(),
            check_in: $(this).find('input[name="check_in"]').val(),
            check_out: $(this).find('input[name="check_out"]').val()
        };

        $.post(hrm_admin_params.ajaxurl || ajaxurl, formData, function (response) {
            if (response.success) {
                location.reload();
            } else {
                alert('Error: ' + (response.data || 'Unknown error'));
                $submitBtn.removeClass('loading').prop('disabled', false);
            }
        }).fail(function () {
            alert('Server Error');
            $submitBtn.removeClass('loading').prop('disabled', false);
        });
    });

    // Global Modal Helpers (for inline onclick compatibility)
    window.openModal = function (id) {
        $('#' + id).fadeIn(200);
    };

    window.closeModal = function (id) {
        $('#' + id).fadeOut(200);
    };

    // Close manual modal on click outside
    $manualAttModal.on('click', function (e) {
        if ($(e.target).is($manualAttModal)) {
            $manualAttModal.fadeOut(200);
        }
    });

    // --- Bulk Delete Logic ---
    const $selectAllToggle = $('#hrm-select-all-toggle');
    const $rowCheckboxes = $('.hrm-row-checkbox');
    const $bulkDeleteBtn = $('#hrm-delete-bulk-btn');

    function updateBulkUI() {
        const checkedCount = $('.hrm-row-checkbox:checked').length;
        if (checkedCount > 0) {
            $bulkDeleteBtn.fadeIn(200).css('display', 'flex');
        } else {
            $bulkDeleteBtn.fadeOut(200);
        }
    }

    $selectAllToggle.on('change', function () {
        const isChecked = $(this).is(':checked');
        $rowCheckboxes.prop('checked', isChecked);
        updateBulkUI();
    });

    $(document).on('change', '.hrm-row-checkbox', function () {
        const allChecked = $rowCheckboxes.length === $('.hrm-row-checkbox:checked').length;
        $selectAllToggle.prop('checked', allChecked);
        updateBulkUI();
    });

    $bulkDeleteBtn.on('click', function (e) {
        e.preventDefault();

        const selectedIds = [];
        $('.hrm-row-checkbox:checked').each(function () {
            selectedIds.push($(this).val());
        });

        if (selectedIds.length === 0) return;

        if (!confirm('Are you sure you want to delete ' + selectedIds.length + ' records? This cannot be undone.')) {
            return;
        }

        const $btn = $(this);
        $btn.addClass('loading').prop('disabled', true);

        $.post(hrm_admin_params.ajaxurl || ajaxurl, {
            action: 'hrm_delete_attendance',
            nonce: hrm_admin_params.nonce,
            ids: selectedIds
        }, function (response) {
            if (response.success) {
                location.reload();
            } else {
                alert('Error: ' + response.data);
                $btn.removeClass('loading').prop('disabled', false);
            }
        }).fail(function () {
            alert('Server Error');
            $btn.removeClass('loading').prop('disabled', false);
        });
    });

    // --- Animated Counter ---
    $('.stat-number').each(function () {
        const $this = $(this);
        const textVal = $this.text();
        const countTo = parseInt(textVal.replace(/,/g, ''));

        if (!isNaN(countTo) && countTo > 0) {
            $({ countNum: 0 }).animate({
                countNum: countTo
            }, {
                duration: 1500,
                easing: 'swing',
                step: function () {
                    $this.text(Math.ceil(this.countNum));
                },
                complete: function () {
                    $this.text(countTo);
                }
            });
        }
    });

    // --- Task Detail Modal (Daily Progress) ---
    $(document).on('click', '.hrm-view-task-details', function (e) {
        e.preventDefault();
        const btn = $(this);
        const progressId = btn.data('progress-id');
        const taskId = btn.data('task-id');

        // 1. Open Modal
        $('#hrm-task-detail-modal').fadeIn(200);

        // 2. Reset / Loading State
        $('#hrm-modal-loader').show();
        $('#hrm-modal-content').hide();
        $('#modal-task-title-header').text('Task Details');
        $('#modal-task-id-display').text('TASK-' + taskId);

        // 3. Fetch Details
        $.post(hrm_admin_params.ajaxurl || ajaxurl, {
            action: 'hrm_get_progress_details',
            nonce: hrm_admin_params.nonce,
            id: progressId
        }, function (response) {
            if (response.success) {
                const data = response.data;

                // 4. Populate Data
                $('#modal-task-title-header').text(data.task_title);

                // Status Badge
                let statusBadge = '';
                if (data.task_status === 'completed') {
                    statusBadge = '<span class="hrm-badge badge-green">Completed</span>';
                } else {
                    statusBadge = '<span class="hrm-badge badge-blue">' + (data.task_status.replace('_', ' ') || 'Pending') + '</span>';
                }
                $('#modal-status-badge').html(statusBadge);

                $('#modal-date').text(data.date);
                $('#modal-employee').text(data.employee_name);
                $('#modal-hours').text(data.hours_logged + ' hrs');

                // Description handling
                $('#modal-task-desc').html(data.task_desc ? nl2br(escapeHtml(data.task_desc)) : '<em class="text-muted">No description provided.</em>');
                $('#modal-emp-comment').html(data.progress_desc ? nl2br(escapeHtml(data.progress_desc)) : '<em class="text-muted">No details provided.</em>');
                $('#modal-admin-comment').html(data.admin_comment ? nl2br(escapeHtml(data.admin_comment)) : 'No feedback yet.');

                // 5. Show Content
                $('#hrm-modal-loader').hide();
                $('#hrm-modal-content').fadeIn(200);
            } else {
                alert('Error loading details: ' + (response.data || 'Unknown error'));
                $('#hrm-task-detail-modal').fadeOut(200);
            }
        }).fail(function () {
            alert('Server error while loading details.');
            $('#hrm-task-detail-modal').fadeOut(200);
        });
    });

    // Helper functions for safely rendering HTML
    function escapeHtml(text) {
        if (!text) return '';
        var map = {
            '&': '&amp;',
            '<': '&lt;',
            '>': '&gt;',
            '"': '&quot;',
            "'": '&#039;'
        };
        return text.toString().replace(/[&<>"']/g, function (m) { return map[m]; });
    }

    function nl2br(str) {
        if (!str) return '';
        return str.replace(/(?:\r\n|\r|\n)/g, '<br>');
    }

    // --- Payroll Settings Form ---
    $(document).on('submit', '#hrm-payroll-settings-form', function (e) {
        e.preventDefault();
        const $form = $(this);
        const $btn = $form.find('button[type="submit"]');
        const originalText = $btn.html();

        $btn.prop('disabled', true).addClass('loading');

        $.post(typeof hrm_admin_params !== 'undefined' ? hrm_admin_params.ajaxurl : ajaxurl, $form.serialize(), function (res) {
            if (res.success) {
                hrmToast('success', res.data || 'Settings saved successfully.');
            } else {
                hrmToast('error', res.data || 'Failed to save settings.');
            }
            $btn.prop('disabled', false).removeClass('loading').html(originalText);
        }).fail(function () {
            hrmToast('error', 'Server error. Please try again.');
            $btn.prop('disabled', false).removeClass('loading').html(originalText);
        });
    });

    // --- Salary Structure Form ---
    $(document).on('submit', '#hrm-salary-structure-form', function (e) {
        e.preventDefault();
        const $form = $(this);
        const $btn = $form.find('button[type="submit"]');
        const originalText = $btn.html();

        $btn.prop('disabled', true).addClass('loading');

        $.post(typeof hrm_admin_params !== 'undefined' ? hrm_admin_params.ajaxurl : ajaxurl, $form.serialize(), function (res) {
            if (res.success) {
                hrmToast('success', 'Salary structure saved.');
                setTimeout(() => { location.reload(); }, 1000);
            } else {
                hrmToast('error', res.data || 'Failed to save salary structure.');
                $btn.prop('disabled', false).removeClass('loading').html(originalText);
            }
        }).fail(function () {
            hrmToast('error', 'Server error. Please try again.');
            $btn.prop('disabled', false).removeClass('loading').html(originalText);
        });
    });

    // --- Dashboard Settings Form ---
    $(document).on('submit', '#hrm-dashboard-settings-form', function (e) {
        e.preventDefault();
        const $form = $(this);
        const $btn = $form.find('button[type="submit"]');
        const originalText = $btn.html();

        $btn.prop('disabled', true).addClass('loading');

        $.post(typeof hrm_admin_params !== 'undefined' ? hrm_admin_params.ajaxurl : ajaxurl, $form.serialize(), function (res) {
            if (res.success) {
                hrmToast('success', res.data || 'Settings saved.');
            } else {
                hrmToast('error', res.data || 'Failed to save.');
            }
            $btn.prop('disabled', false).removeClass('loading').html(originalText);
        }).fail(function () {
            hrmToast('error', 'Server error.');
            $btn.prop('disabled', false).removeClass('loading').html(originalText);
        });
    });

    // --- IP Config: Add IP ---
    $(document).on('click', '#add-ip-btn', function () {
        const btn = $(this);
        const ip = $('#new-ip-address').val().trim();
        const label = $('#new-ip-label').val().trim();
        const type = $('#new-ip-type').val();

        if (!ip) {
            hrmToast('error', 'Please enter an IP address.');
            $('#new-ip-address').focus();
            return;
        }

        btn.addClass('loading').prop('disabled', true);

        $.post(typeof hrm_admin_params !== 'undefined' ? hrm_admin_params.ajaxurl : ajaxurl, {
            action: 'hrm_add_ip',
            nonce: typeof hrm_admin_params !== 'undefined' ? hrm_admin_params.nonce : '',
            ip: ip,
            label: label,
            type: type
        }, function (response) {
            btn.removeClass('loading').prop('disabled', false);
            if (response.success) {
                hrmToast('success', response.data.message);
                location.reload();
            } else {
                hrmToast('error', response.data.message || 'Failed to add IP address.');
            }
        }).fail(function () {
            btn.removeClass('loading').prop('disabled', false);
            hrmToast('error', 'An error occurred. Please try again.');
        });
    });

    // --- IP Config: Save Changes (Edit) ---
    $(document).on('click', '#save-ip-btn', function () {
        const btn = $(this);
        const id = $('#edit-ip-id').val();
        const ip = $('#edit-ip-address').val().trim();
        const label = $('#edit-ip-label').val().trim();
        const type = $('#edit-ip-type').val();

        if (!ip) {
            hrmToast('error', 'Please enter an IP address.');
            return;
        }

        btn.addClass('loading').prop('disabled', true);

        $.post(typeof hrm_admin_params !== 'undefined' ? hrm_admin_params.ajaxurl : ajaxurl, {
            action: 'hrm_update_ip',
            nonce: typeof hrm_admin_params !== 'undefined' ? hrm_admin_params.nonce : '',
            id: id,
            ip: ip,
            label: label,
            type: type
        }, function (response) {
            btn.removeClass('loading').prop('disabled', false);
            if (response.success) {
                hrmToast('success', response.data.message);
                location.reload();
            } else {
                hrmToast('error', response.data.message || 'Failed to update IP address.');
            }
        }).fail(function () {
            btn.removeClass('loading').prop('disabled', false);
            hrmToast('error', 'An error occurred. Please try again.');
        });
    });

    // --- IP Config: Toggle Status ---
    $(document).on('change', '.ip-toggle-checkbox', function () {
        const checkbox = $(this);
        const item = checkbox.closest('.hrm-ip-item');
        const id = item.data('id');
        const enabled = checkbox.is(':checked');

        $.post(typeof hrm_admin_params !== 'undefined' ? hrm_admin_params.ajaxurl : ajaxurl, {
            action: 'hrm_toggle_ip_status',
            nonce: typeof hrm_admin_params !== 'undefined' ? hrm_admin_params.nonce : '',
            id: id,
            enabled: enabled.toString()
        }, function (response) {
            if (response.success) {
                item.toggleClass('enabled', enabled).toggleClass('disabled', !enabled);
            } else {
                checkbox.prop('checked', !enabled);
                hrmToast('error', response.data.message || 'Failed to update status.');
            }
        });
    });

    // --- IP Config: Confirm Delete ---
    $(document).on('click', '#confirm-delete-ip-btn', function () {
        const btn = $(this);
        const id = $('#delete-ip-id').val();

        btn.addClass('loading').prop('disabled', true);

        $.post(typeof hrm_admin_params !== 'undefined' ? hrm_admin_params.ajaxurl : ajaxurl, {
            action: 'hrm_delete_ip',
            nonce: typeof hrm_admin_params !== 'undefined' ? hrm_admin_params.nonce : '',
            id: id
        }, function (response) {
            btn.removeClass('loading').prop('disabled', false);
            if (response.success) {
                hrmToast('success', response.data.message);
                location.reload();
            } else {
                hrmToast('error', response.data.message || 'Failed to delete IP address.');
            }
        }).fail(function () {
            btn.removeClass('loading').prop('disabled', false);
            hrmToast('error', 'An error occurred. Please try again.');
        });
    });

    // --- Bulk Attendance Logic ---
    $(document).on('change', '#bulk-select-all-emps', function () {
        $('.bulk-emp-checkbox').prop('checked', $(this).prop('checked'));
    });

    $(document).on('submit', '#hrm-bulk-attendance-form', function (e) {
        e.preventDefault();
        const $form = $(this);
        const $btn = $form.find('button[type="submit"]');
        const originalText = $btn.text();

        if ($('.bulk-emp-checkbox:checked').length === 0) {
            window.hrmToast('error', 'Please select at least one employee.');
            return;
        }

        $btn.text('Processing...').prop('disabled', true);

        $.post(typeof hrm_admin_params !== 'undefined' ? hrm_admin_params.ajaxurl : ajaxurl, $form.serialize(), function (res) {
            if (res.success) {
                window.hrmToast('success', res.data);
                setTimeout(function () { location.reload(); }, 1000);
            } else {
                window.hrmToast('error', res.data);
                $btn.text(originalText).prop('disabled', false);
            }
        });
    });
});